/////////////////////////////////////////////////////////////////
//
//	LZElzedDLL.h
//
//	Part of the LZ Supplemental Library
//
//	Copyright (c) 2000-2010 by R R Le Cropane
//	All Rights Reserved
//
/////////////////////////////////////////////////////////////////

#ifndef __LZElzedDLL__
#define __LZElzedDLL__

/////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////

#include <LZElzedPublic.h>

/////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////

// Elzed DLL Imported Functions
typedef char* (ELZED_CALL_TYPE *LZ_ANNOTATE_EXP)( char* );
typedef BSTR (ELZED_CALL_TYPE *LZ_ANNOTATE_EXP_B)( char* );
typedef char* (ELZED_CALL_TYPE *LZ_ANNOTATE_PARSED_EXP)( LZObjectHandle );
typedef BSTR (ELZED_CALL_TYPE *LZ_ANNOTATE_PARSED_EXP_B)( LZObjectHandle );

typedef char* (ELZED_CALL_TYPE *LZ_CHECK_EXP)( char* );
typedef BSTR (ELZED_CALL_TYPE *LZ_CHECK_EXP_B)( char* );
typedef bool (ELZED_CALL_TYPE *LZ_CLEAR_CONTEXT)( void );
typedef bool (ELZED_CALL_TYPE *LZ_CLEAR_ERROR_CALLBACK)( void );
typedef void (ELZED_CALL_TYPE *LZ_CLEAR_LAST_ERROR)( void );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_BOOL_ARRAY)( char, char*, long, long, long, long, long, long, long );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_BOOL_VAR)( char, char*, bool );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_COMPLEX_ARRAY)( char, char*, long, long, long, long, long, long, long );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_COMPLEX_VAR)( char, char*, double, double );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_NUM_ARRAY)( char, char*, long, long, long, long, long, long, long );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_NUM_VAR)( char, char*, double );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_PRIVATE_CONTEXT)( char* );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_PUBLIC_CONTEXT)( char* );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_STR_ARRAY)( char, char*, long, long, long, long, long, long, long, long );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_CREATE_STR_VAR)( char, char*, long, char* );

typedef bool (ELZED_CALL_TYPE *LZ_DEFINE_ERROR)( char, long, char* );
typedef long (ELZED_CALL_TYPE *LZ_DEFINE_EXP_OP)( char, char*, char*, char*, char*, char*, char* );
typedef long (ELZED_CALL_TYPE *LZ_DEFINE_EXP_OP_STR)( char, char*, char* );
typedef void (ELZED_CALL_TYPE *LZ_DELETE_EXP)( LZObjectHandle );
typedef long (ELZED_CALL_TYPE *LZ_DELETE_OP)( char, char* );
typedef long (ELZED_CALL_TYPE *LZ_DELETE_VAR)( char, char* );
typedef bool (ELZED_CALL_TYPE *LZ_DESTROY_PRIVATE_CONTEXT)( char* );
typedef bool (ELZED_CALL_TYPE *LZ_DESTROY_PUBLIC_CONTEXT)( char* );

typedef char (ELZED_CALL_TYPE *LZ_EVAL_EXP_HNDL)( LZObjectHandle );
typedef bool (ELZED_CALL_TYPE *LZ_EVAL_EXP_HNDL_TO_BOOL)( LZObjectHandle );
typedef double (ELZED_CALL_TYPE *LZ_EVAL_EXP_HNDL_TO_COMP)( LZObjectHandle, double* );
typedef double (ELZED_CALL_TYPE *LZ_EVAL_EXP_HNDL_TO_NUM)( LZObjectHandle );
typedef char* (ELZED_CALL_TYPE *LZ_EVAL_EXP_HNDL_TO_STR)( LZObjectHandle );
typedef BSTR (ELZED_CALL_TYPE *LZ_EVAL_EXP_HNDL_TO_STR_B)( LZObjectHandle );
typedef char (ELZED_CALL_TYPE *LZ_EVAL_EXP_STR)( char* );
typedef bool (ELZED_CALL_TYPE *LZ_EVAL_EXP_STR_TO_BOOL)( char* );
typedef double (ELZED_CALL_TYPE *LZ_EVAL_EXP_STR_TO_COMP)( char*, double* );
typedef double (ELZED_CALL_TYPE *LZ_EVAL_EXP_STR_TO_NUM)( char* );
typedef char* (ELZED_CALL_TYPE *LZ_EVAL_EXP_STR_TO_STR)( char* );
typedef BSTR (ELZED_CALL_TYPE *LZ_EVAL_EXP_STR_TO_STR_B)( char* );

typedef bool (ELZED_CALL_TYPE *LZ_GET_ALLOW_COMPLEX_RESULTS)( void );
typedef bool (ELZED_CALL_TYPE *LZ_GET_ALLOW_IMPLIED_MULT)( void );
typedef char (ELZED_CALL_TYPE *LZ_GET_ANGLE_UNIT)( void );
typedef char (ELZED_CALL_TYPE *LZ_GET_BOOLEAN_TRUE)( void );
typedef bool (ELZED_CALL_TYPE *LZ_GET_BOOL_ARRAY_ELEMENT)( char, char*, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_GET_BOOL_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_GET_BOOL_PARM)( LZObjectHandle, long );
typedef bool (ELZED_CALL_TYPE *LZ_GET_BOOL_VAR_VALUE)( char, char* );
typedef bool (ELZED_CALL_TYPE *LZ_GET_BOOL_VAR_VALUE_BY_HANDLE)( LZObjectHandle );
typedef bool (ELZED_CALL_TYPE *LZ_GET_COMPLEX_ARRAY_ELEMENT)( char, char*, double*, double*, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_GET_COMPLEX_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, double*, double*, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_GET_COMPLEX_VAR_VALUE)( char, char*, double*, double* );
typedef bool (ELZED_CALL_TYPE *LZ_GET_COMPLEX_VAR_VALUE_BY_HANDLE)( LZObjectHandle, double*, double* );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_GET_CONTEXT_HANDLE)( char* );
typedef char* (ELZED_CALL_TYPE *LZ_GET_CONTEXT_NAME)( LZObjectHandle );
typedef BSTR (ELZED_CALL_TYPE *LZ_GET_CONTEXT_NAME_B)( LZObjectHandle );
typedef char (ELZED_CALL_TYPE *LZ_GET_COORDINATE_FORMAT)( void );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_GET_CURRENT_CONTEXT_HANDLE)( void );
typedef char* (ELZED_CALL_TYPE *LZ_GET_CURRENT_CONTEXT_NAME)( void );
typedef BSTR (ELZED_CALL_TYPE *LZ_GET_CURRENT_CONTEXT_NAME_B)( void );
typedef char (ELZED_CALL_TYPE *LZ_GET_DEFAULT_VARIABLE_SCOPE)( void );
typedef char* (ELZED_CALL_TYPE *LZ_GET_ERROR_TEXT)( long );
typedef BSTR (ELZED_CALL_TYPE *LZ_GET_ERROR_TEXT_B)( long );
typedef int (ELZED_CALL_TYPE *LZ_GET_FORMATTED_RESULT_PRECISION_LIMIT)( void );
typedef bool (ELZED_CALL_TYPE *LZ_GET_FORCE_COMPLEX_RESULTS)( void );
typedef double (ELZED_CALL_TYPE *LZ_GET_IMAG_PARM)( LZObjectHandle, long );
typedef bool (ELZED_CALL_TYPE *LZ_GET_INVERT_ARRAY_INDICES)( void );
typedef bool (ELZED_CALL_TYPE *LZ_GET_LAST_BOOL_RESULT)( void );
typedef long (ELZED_CALL_TYPE *LZ_GET_LAST_ERROR_ID)( void );
typedef char* (ELZED_CALL_TYPE *LZ_GET_LAST_ERROR_TEXT)( void );
typedef BSTR (ELZED_CALL_TYPE *LZ_GET_LAST_ERROR_TEXT_B)( void );
typedef double (ELZED_CALL_TYPE *LZ_GET_LAST_IMAG_RESULT)( void );
typedef double (ELZED_CALL_TYPE *LZ_GET_LAST_NUM_RESULT)( void );
typedef long (ELZED_CALL_TYPE *LZ_GET_LAST_PARSE_INDEX)( void );
typedef double (ELZED_CALL_TYPE *LZ_GET_LAST_REAL_RESULT)( void );
typedef char (ELZED_CALL_TYPE *LZ_GET_LAST_RESULT_TYPE)( void );
typedef char* (ELZED_CALL_TYPE *LZ_GET_LAST_STR_RESULT)( void );
typedef BSTR (ELZED_CALL_TYPE *LZ_GET_LAST_STR_RESULT_B)( void );
typedef double (ELZED_CALL_TYPE *LZ_GET_NUM_ARRAY_ELEMENT)( char, char*, long, long, long, long, long, long, long );
typedef double (ELZED_CALL_TYPE *LZ_GET_NUM_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, long, long, long, long, long, long, long );
typedef double (ELZED_CALL_TYPE *LZ_GET_NUM_PARM)( LZObjectHandle, long );
typedef double (ELZED_CALL_TYPE *LZ_GET_NUM_VAR_VALUE)( char, char* );
typedef double (ELZED_CALL_TYPE *LZ_GET_NUM_VAR_VALUE_BY_HANDLE)( LZObjectHandle );
typedef char (ELZED_CALL_TYPE *LZ_GET_OUTPUT_BASE)( void );
typedef long (ELZED_CALL_TYPE *LZ_GET_PARM_COUNT)( LZObjectHandle );
typedef char* (ELZED_CALL_TYPE *LZ_GET_PARM_SIG)( LZObjectHandle );
typedef BSTR (ELZED_CALL_TYPE *LZ_GET_PARM_SIG_B)( LZObjectHandle );
typedef char (ELZED_CALL_TYPE *LZ_GET_PARM_TYPE)( LZObjectHandle, long );
typedef char (ELZED_CALL_TYPE *LZ_GET_QUOTE_MARK)( void );
typedef char (ELZED_CALL_TYPE *LZ_GET_RADIX_MARK)( void );
typedef double (ELZED_CALL_TYPE *LZ_GET_REAL_PARM)( LZObjectHandle, long );
typedef char* (ELZED_CALL_TYPE *LZ_GET_STR_ARRAY_ELEMENT)( char, char*, long, long , long, long, long, long, long );
typedef BSTR (ELZED_CALL_TYPE *LZ_GET_STR_ARRAY_ELEMENT_B)( char, char*, long, long, long, long, long, long, long );
typedef char* (ELZED_CALL_TYPE *LZ_GET_STR_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, long, long, long, long, long, long, long );
typedef char* (ELZED_CALL_TYPE *LZ_GET_STR_ARRAY_ELEMENT_BY_HANDLE_B)( LZObjectHandle, long, long, long, long, long, long, long );
typedef char* (ELZED_CALL_TYPE *LZ_GET_STR_PARM)( LZObjectHandle, long );
typedef BSTR (ELZED_CALL_TYPE *LZ_GET_STR_PARM_B)( LZObjectHandle, long );
typedef char* (ELZED_CALL_TYPE *LZ_GET_STR_VAR_VALUE)( char, char* );
typedef BSTR (ELZED_CALL_TYPE *LZ_GET_STR_VAR_VALUE_B)( char, char* );
typedef char* (ELZED_CALL_TYPE *LZ_GET_STR_VAR_VALUE_BY_HANDLE)( LZObjectHandle );
typedef char* (ELZED_CALL_TYPE *LZ_GET_STR_VAR_VALUE_BY_HANDLE_B)( LZObjectHandle );
typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_GET_VAR_HANDLE)( char, char* );
typedef char (ELZED_CALL_TYPE *LZ_GET_VAR_TYPE)( char, char* );
typedef char (ELZED_CALL_TYPE *LZ_GET_VAR_TYPE_BY_HANDLE)( LZObjectHandle );

typedef bool (ELZED_CALL_TYPE *LZ_INITIALIZE)( char* );
typedef bool (ELZED_CALL_TYPE *LZ_IS_ARRAY)( char, char* );
typedef bool (ELZED_CALL_TYPE *LZ_IS_ARRAY_HANDLE)( LZObjectHandle );
typedef bool (ELZED_CALL_TYPE *LZ_IS_OP)( char, char* );
typedef bool (ELZED_CALL_TYPE *LZ_IS_SYMBOL)( char, char* );
typedef bool (ELZED_CALL_TYPE *LZ_IS_VAR)( char, char* );
typedef bool (ELZED_CALL_TYPE *LZ_IS_VAR_HANDLE)( LZObjectHandle );

typedef bool (ELZED_CALL_TYPE *LZ_LINK_BOOL_ARRAY)( char, char*, bool*, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_LINK_BOOL_VAR)( char, char*, bool* );
typedef long (ELZED_CALL_TYPE *LZ_LINK_CALLBACK_OP)( char, char*, char*, char*, char*, char*, ExtOpFunction );
typedef bool (ELZED_CALL_TYPE *LZ_LINK_COMPLEX_ARRAY)( char, char*, double*, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_LINK_COMPLEX_VAR)( char, char*, double* );
typedef bool (ELZED_CALL_TYPE *LZ_LINK_NUM_ARRAY)( char, char*, double*, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_LINK_NUM_VAR)( char, char*, double* );
typedef bool (ELZED_CALL_TYPE *LZ_LINK_STR_ARRAY)( char, char*, char*, long, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_LINK_STR_VAR)( char, char*, char*, long );
typedef bool (ELZED_CALL_TYPE *LZ_LOCK_CONTEXT)( void );

typedef LZObjectHandle (ELZED_CALL_TYPE *LZ_PARSE_EXP)( char* );

typedef long (ELZED_CALL_TYPE *LZ_READ_EXP_OP)( char, char*, char*, char*, char*, char*, char* );
typedef long (ELZED_CALL_TYPE *LZ_READ_EXP_OP_STR)( char, char*, char* );
typedef bool (ELZED_CALL_TYPE *LZ_RELEASE)( void );
typedef bool (ELZED_CALL_TYPE *LZ_RELEASE_CONTEXT)( void );
typedef bool (ELZED_CALL_TYPE *LZ_RESET)( void );
typedef bool (ELZED_CALL_TYPE *LZ_RESET_DEFAULT_CONTEXT)( void );
typedef char* (ELZED_CALL_TYPE *LZ_REVERT_PARSED_EXP)( LZObjectHandle );
typedef BSTR (ELZED_CALL_TYPE *LZ_REVERT_PARSED_EXP_B)( LZObjectHandle );

typedef void (ELZED_CALL_TYPE *LZ_SET_ALLOW_COMPLEX_RESULTS)( bool );
typedef void (ELZED_CALL_TYPE *LZ_SET_ALLOW_IMPLIED_MULT)( bool );
typedef void (ELZED_CALL_TYPE *LZ_SET_ANGLE_UNIT)( char );
typedef void (ELZED_CALL_TYPE *LZ_SET_BOOLEAN_TRUE)( char );
typedef bool (ELZED_CALL_TYPE *LZ_SET_BOOL_ARRAY_ELEMENT)( char, char*, bool, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_SET_BOOL_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, bool, long, long, long, long, long, long, long );
typedef long (ELZED_CALL_TYPE *LZ_SET_BOOL_RESULT)( LZObjectHandle, bool );
typedef bool (ELZED_CALL_TYPE *LZ_SET_BOOL_VAR)( char, char*, bool );
typedef bool (ELZED_CALL_TYPE *LZ_SET_BOOL_VAR_BY_HANDLE)( LZObjectHandle, bool );
typedef bool (ELZED_CALL_TYPE *LZ_SET_COMPLEX_ARRAY_ELEMENT)( char, char*, double, double, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_SET_COMPLEX_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, double, double, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_SET_COMPLEX_VAR)( char, char*, double, double );
typedef bool (ELZED_CALL_TYPE *LZ_SET_COMPLEX_VAR_BY_HANDLE)( LZObjectHandle, double, double );
typedef bool (ELZED_CALL_TYPE *LZ_SET_CONTEXT)( char*, bool );
typedef void (ELZED_CALL_TYPE *LZ_SET_COORDINATE_FORMAT)( char );
typedef bool (ELZED_CALL_TYPE *LZ_SET_DEFAULT_CONTEXT)( char* );
typedef void (ELZED_CALL_TYPE *LZ_SET_DEFAULT_VARIABLE_SCOPE)( char );
typedef bool (ELZED_CALL_TYPE *LZ_SET_ERROR_CALLBACK)( ErrorFunction );
typedef void (ELZED_CALL_TYPE *LZ_SET_FORCE_COMPLEX_RESULTS)( bool );
typedef void (ELZED_CALL_TYPE *LZ_SET_FORMATTED_RESULT_PRECISION_LIMIT)( int );
typedef bool (ELZED_CALL_TYPE *LZ_SET_IMAG_ARRAY_ELEMENT)( char, char*, double, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_SET_IMAG_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, double, long, long, long, long, long, long, long );
typedef long (ELZED_CALL_TYPE *LZ_SET_IMAG_RESULT)( LZObjectHandle, double );
typedef bool (ELZED_CALL_TYPE *LZ_SET_IMAG_VAR)( char, char*, double );
typedef bool (ELZED_CALL_TYPE *LZ_SET_IMAG_VAR_BY_HANDLE)( LZObjectHandle, double );
typedef void (ELZED_CALL_TYPE *LZ_SET_INVERT_ARRAY_INDICES)( bool );
typedef void (ELZED_CALL_TYPE *LZ_SET_LAST_ERROR)( long );
typedef bool (ELZED_CALL_TYPE *LZ_SET_NUM_ARRAY_ELEMENT)( char, char*, double, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_SET_NUM_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, double, long, long, long, long, long, long, long );
typedef long (ELZED_CALL_TYPE *LZ_SET_NUM_RESULT)( LZObjectHandle, double );
typedef bool (ELZED_CALL_TYPE *LZ_SET_NUM_VAR)( char, char*, double);
typedef bool (ELZED_CALL_TYPE *LZ_SET_NUM_VAR_BY_HANDLE)( LZObjectHandle, double );
typedef void (ELZED_CALL_TYPE *LZ_SET_OUTPUT_BASE)( char );
typedef void (ELZED_CALL_TYPE *LZ_SET_QUOTE_MARK)( char );
typedef void (ELZED_CALL_TYPE *LZ_SET_RADIX_MARK)( char );
typedef bool (ELZED_CALL_TYPE *LZ_SET_REAL_ARRAY_ELEMENT)( char, char*, double, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_SET_REAL_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, double, long, long, long, long, long, long, long );
typedef long (ELZED_CALL_TYPE *LZ_SET_REAL_RESULT)( LZObjectHandle, double );
typedef bool (ELZED_CALL_TYPE *LZ_SET_REAL_VAR)( char, char*, double );
typedef bool (ELZED_CALL_TYPE *LZ_SET_REAL_VAR_BY_HANDLE)( LZObjectHandle, double );
typedef bool (ELZED_CALL_TYPE *LZ_SET_STR_ARRAY_ELEMENT)( char, char*, char*, long, long, long, long, long, long, long );
typedef bool (ELZED_CALL_TYPE *LZ_SET_STR_ARRAY_ELEMENT_BY_HANDLE)( LZObjectHandle, char*, long, long, long, long, long, long, long );
typedef long (ELZED_CALL_TYPE *LZ_SET_STR_RESULT)( LZObjectHandle, char* );
typedef bool (ELZED_CALL_TYPE *LZ_SET_STR_VAR)( char, char*, char* );
typedef bool (ELZED_CALL_TYPE *LZ_SET_STR_VAR_BY_HANDLE)( LZObjectHandle, char* );
typedef void (ELZED_CALL_TYPE *LZ_SHOW_INFO_BOX)( void );

typedef double (ELZED_CALL_TYPE *LZ_VERSION)( void );


/////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////

// "Standard" Elzed DLL Imported Function Pointers
LZ_ANNOTATE_EXP lzAnnotateExp = NULL;
LZ_ANNOTATE_EXP_B lzAnnotateExpB = NULL;
LZ_ANNOTATE_PARSED_EXP lzAnnotateParsedExp = NULL;
LZ_ANNOTATE_PARSED_EXP_B lzAnnotateParsedExpB = NULL;

LZ_CHECK_EXP lzCheckExp = NULL;
LZ_CHECK_EXP_B lzCheckExpB = NULL;
LZ_CLEAR_CONTEXT lzClearContext = NULL;
LZ_CLEAR_ERROR_CALLBACK lzClearErrorCallback = NULL;
LZ_CLEAR_LAST_ERROR lzClearLastError = NULL;
LZ_CREATE_BOOL_ARRAY lzCreateBoolArray = NULL;
LZ_CREATE_BOOL_VAR lzCreateBoolVar = NULL;
LZ_CREATE_COMPLEX_ARRAY lzCreateComplexArray = NULL;
LZ_CREATE_COMPLEX_VAR lzCreateComplexVar = NULL;
LZ_CREATE_NUM_ARRAY lzCreateNumArray = NULL;
LZ_CREATE_NUM_VAR lzCreateNumVar = NULL;
LZ_CREATE_PRIVATE_CONTEXT lzCreatePrivateContext = NULL;
LZ_CREATE_PUBLIC_CONTEXT lzCreatePublicContext = NULL;
LZ_CREATE_STR_ARRAY lzCreateStrArray = NULL;
LZ_CREATE_STR_VAR lzCreateStrVar = NULL;

LZ_DEFINE_ERROR lzDefineError = NULL;
LZ_DEFINE_EXP_OP lzDefineExpOp = NULL;
LZ_DEFINE_EXP_OP_STR lzDefineExpOpStr = NULL;
LZ_DELETE_EXP lzDeleteExp = NULL;
LZ_DELETE_OP lzDeleteOp = NULL;
LZ_DELETE_VAR lzDeleteVar = NULL;
LZ_DESTROY_PRIVATE_CONTEXT lzDestroyPrivateContext = NULL;
LZ_DESTROY_PUBLIC_CONTEXT lzDestroyPublicContext = NULL;

LZ_EVAL_EXP_HNDL lzEvalExpHndl = NULL;
LZ_EVAL_EXP_HNDL_TO_BOOL lzEvalExpHndlToBool = NULL;
LZ_EVAL_EXP_HNDL_TO_COMP lzEvalExpHndlToComp = NULL;
LZ_EVAL_EXP_HNDL_TO_NUM lzEvalExpHndlToNum = NULL;
LZ_EVAL_EXP_HNDL_TO_STR lzEvalExpHndlToStr = NULL;
LZ_EVAL_EXP_HNDL_TO_STR_B lzEvalExpHndlToStrB = NULL;
LZ_EVAL_EXP_STR lzEvalExpStr = NULL;
LZ_EVAL_EXP_STR_TO_BOOL lzEvalExpStrToBool = NULL;
LZ_EVAL_EXP_STR_TO_COMP lzEvalExpStrToComp = NULL;
LZ_EVAL_EXP_STR_TO_NUM lzEvalExpStrToNum = NULL;
LZ_EVAL_EXP_STR_TO_STR lzEvalExpStrToStr = NULL;
LZ_EVAL_EXP_STR_TO_STR_B lzEvalExpStrToStrB = NULL;

LZ_GET_ALLOW_COMPLEX_RESULTS lzGetAllowComplexResults = NULL;
LZ_GET_ALLOW_IMPLIED_MULT lzGetAllowImpliedMult = NULL;
LZ_GET_ANGLE_UNIT lzGetAngleUnit = NULL;
LZ_GET_BOOLEAN_TRUE lzGetBooleanTrue = NULL;
LZ_GET_BOOL_ARRAY_ELEMENT lzGetBoolArrayElement = NULL;
LZ_GET_BOOL_ARRAY_ELEMENT_BY_HANDLE lzGetBoolArrayElementByHandle = NULL;
LZ_GET_BOOL_PARM lzGetBoolParm = NULL;
LZ_GET_BOOL_VAR_VALUE lzGetBoolVarValue = NULL;
LZ_GET_BOOL_VAR_VALUE_BY_HANDLE lzGetBoolVarValueByHandle = NULL;
LZ_GET_COMPLEX_ARRAY_ELEMENT lzGetComplexArrayElement = NULL;
LZ_GET_COMPLEX_ARRAY_ELEMENT_BY_HANDLE lzGetComplexArrayElementByHandle = NULL;
LZ_GET_COMPLEX_VAR_VALUE lzGetComplexVarValue = NULL;
LZ_GET_COMPLEX_VAR_VALUE_BY_HANDLE lzGetComplexVarValueByHandle = NULL;
LZ_GET_CONTEXT_HANDLE lzGetContextHandle = NULL;
LZ_GET_CONTEXT_NAME lzGetContextName = NULL;
LZ_GET_CONTEXT_NAME_B lzGetContextNameB = NULL;
LZ_GET_COORDINATE_FORMAT lzGetCoordinateFormat = NULL;
LZ_GET_CURRENT_CONTEXT_HANDLE lzGetCurrentContextHandle = NULL;
LZ_GET_CURRENT_CONTEXT_NAME lzGetCurrentContextName = NULL;
LZ_GET_CURRENT_CONTEXT_NAME_B lzGetCurrentContextNameB = NULL;
LZ_GET_DEFAULT_VARIABLE_SCOPE lzGetDefaultVariableScope = NULL;
LZ_GET_ERROR_TEXT lzGetErrorText = NULL;
LZ_GET_ERROR_TEXT_B lzGetErrorTextB = NULL;
LZ_GET_FORCE_COMPLEX_RESULTS lzGetForceComplexResults = NULL;
LZ_GET_FORMATTED_RESULT_PRECISION_LIMIT lzGetFormattedResultPrecisionLimit = NULL;
LZ_GET_IMAG_PARM lzGetImagParm = NULL;
LZ_GET_INVERT_ARRAY_INDICES lzGetInvertArrayIndices = NULL;
LZ_GET_LAST_BOOL_RESULT lzGetLastBoolResult = NULL;
LZ_GET_LAST_ERROR_ID lzGetLastErrorID = NULL;
LZ_GET_LAST_ERROR_TEXT lzGetLastErrorText = NULL;
LZ_GET_LAST_ERROR_TEXT_B lzGetLastErrorTextB = NULL;
LZ_GET_LAST_IMAG_RESULT lzGetLastImagResult = NULL;
LZ_GET_LAST_NUM_RESULT lzGetLastNumResult = NULL;
LZ_GET_LAST_PARSE_INDEX lzGetLastParseIndex = NULL;
LZ_GET_LAST_REAL_RESULT lzGetLastRealResult = NULL;
LZ_GET_LAST_RESULT_TYPE lzGetLastResultType = NULL;
LZ_GET_LAST_STR_RESULT lzGetLastStrResult = NULL;
LZ_GET_LAST_STR_RESULT_B lzGetLastStrResultB = NULL;
LZ_GET_NUM_ARRAY_ELEMENT lzGetNumArrayElement = NULL;
LZ_GET_NUM_ARRAY_ELEMENT_BY_HANDLE lzGetNumArrayElementByHandle = NULL;
LZ_GET_NUM_PARM lzGetNumParm = NULL;
LZ_GET_NUM_VAR_VALUE lzGetNumVarValue = NULL;
LZ_GET_NUM_VAR_VALUE_BY_HANDLE lzGetNumVarValueByHandle = NULL;
LZ_GET_OUTPUT_BASE lzGetOutputBase = NULL;
LZ_GET_PARM_COUNT lzGetParmCount = NULL;
LZ_GET_PARM_SIG lzGetParmSig = NULL;
LZ_GET_PARM_SIG_B lzGetParmSigB = NULL;
LZ_GET_PARM_TYPE lzGetParmType = NULL;
LZ_GET_QUOTE_MARK lzGetQuoteMark = NULL;
LZ_GET_RADIX_MARK lzGetRadixMark = NULL;
LZ_GET_REAL_PARM lzGetRealParm = NULL;
LZ_GET_STR_ARRAY_ELEMENT lzGetStrArrayElement = NULL;
LZ_GET_STR_ARRAY_ELEMENT_B lzGetStrArrayElementB = NULL;
LZ_GET_STR_ARRAY_ELEMENT_BY_HANDLE lzGetStrArrayElementByHandle = NULL;
LZ_GET_STR_ARRAY_ELEMENT_BY_HANDLE_B lzGetStrArrayElementByHandleB = NULL;
LZ_GET_STR_PARM lzGetStrParm = NULL;
LZ_GET_STR_PARM_B lzGetStrParmB = NULL;
LZ_GET_STR_VAR_VALUE lzGetStrVarValue = NULL;
LZ_GET_STR_VAR_VALUE_B lzGetStrVarValueB = NULL;
LZ_GET_STR_VAR_VALUE_BY_HANDLE lzGetStrVarValueByHandle = NULL;
LZ_GET_STR_VAR_VALUE_BY_HANDLE_B lzGetStrVarValueByHandleB = NULL;
LZ_GET_VAR_HANDLE lzGetVarHandle = NULL;
LZ_GET_VAR_TYPE lzGetVarType = NULL;
LZ_GET_VAR_TYPE_BY_HANDLE lzGetVarTypeByHandle = NULL;

LZ_INITIALIZE lzInitialize = NULL;
LZ_IS_ARRAY lzIsArray = NULL;
LZ_IS_ARRAY_HANDLE lzIsArrayHandle = NULL;
LZ_IS_OP lzIsOp = NULL;
LZ_IS_SYMBOL lzIsSymbol = NULL;
LZ_IS_VAR lzIsVar = NULL;
LZ_IS_VAR_HANDLE lzIsVarHandle = NULL;

LZ_LINK_BOOL_ARRAY lzLinkBoolArray = NULL;
LZ_LINK_BOOL_VAR lzLinkBoolVar = NULL;
LZ_LINK_CALLBACK_OP lzLinkCallbackOp = NULL;
LZ_LINK_COMPLEX_ARRAY lzLinkComplexArray = NULL;
LZ_LINK_COMPLEX_VAR lzLinkComplexVar = NULL;
LZ_LINK_NUM_ARRAY lzLinkNumArray = NULL;
LZ_LINK_NUM_VAR lzLinkNumVar = NULL;
LZ_LINK_STR_ARRAY lzLinkStrArray = NULL;
LZ_LINK_STR_VAR lzLinkStrVar = NULL;
LZ_LOCK_CONTEXT lzLockContext = NULL;

LZ_PARSE_EXP lzParseExp = NULL;

LZ_READ_EXP_OP lzReadExpOp = NULL;
LZ_READ_EXP_OP_STR lzReadExpOpStr = NULL;
LZ_RELEASE lzRelease = NULL;
LZ_RELEASE_CONTEXT lzReleaseContext = NULL;
LZ_RESET lzReset = NULL;
LZ_RESET_DEFAULT_CONTEXT lzResetDefaultContext = NULL;
LZ_REVERT_PARSED_EXP lzRevertParsedExp = NULL;
LZ_REVERT_PARSED_EXP_B lzRevertParsedExpB = NULL;

LZ_SET_ALLOW_COMPLEX_RESULTS lzSetAllowComplexResults = NULL;
LZ_SET_ALLOW_IMPLIED_MULT lzSetAllowImpliedMult = NULL;
LZ_SET_ANGLE_UNIT lzSetAngleUnit = NULL;
LZ_SET_BOOLEAN_TRUE lzSetBooleanTrue = NULL;
LZ_SET_BOOL_ARRAY_ELEMENT lzSetBoolArrayElement = NULL;
LZ_SET_BOOL_ARRAY_ELEMENT_BY_HANDLE lzSetBoolArrayElementByHandle = NULL;
LZ_SET_BOOL_RESULT lzSetBoolResult = NULL;
LZ_SET_BOOL_VAR lzSetBoolVar = NULL;
LZ_SET_BOOL_VAR_BY_HANDLE lzSetBoolVarByHandle = NULL;
LZ_SET_COMPLEX_ARRAY_ELEMENT lzSetComplexArrayElement = NULL;
LZ_SET_COMPLEX_ARRAY_ELEMENT_BY_HANDLE lzSetComplexArrayElementByHandle = NULL;
LZ_SET_COMPLEX_VAR lzSetComplexVar = NULL;
LZ_SET_COMPLEX_VAR_BY_HANDLE lzSetComplexVarByHandle = NULL;
LZ_SET_CONTEXT lzSetContext = NULL;
LZ_SET_COORDINATE_FORMAT lzSetCoordinateFormat = NULL;
LZ_SET_DEFAULT_CONTEXT lzSetDefaultContext = NULL;
LZ_SET_DEFAULT_VARIABLE_SCOPE lzSetDefaultVariableScope = NULL;
LZ_SET_ERROR_CALLBACK lzSetErrorCallback = NULL;
LZ_SET_FORCE_COMPLEX_RESULTS lzSetForceComplexResults = NULL;
LZ_SET_FORMATTED_RESULT_PRECISION_LIMIT lzSetFormattedResultPrecisionLimit = NULL;
LZ_SET_IMAG_ARRAY_ELEMENT lzSetImagArrayElement = NULL;
LZ_SET_IMAG_ARRAY_ELEMENT_BY_HANDLE lzSetImagArrayElementByHandle = NULL;
LZ_SET_IMAG_RESULT lzSetImagResult = NULL;
LZ_SET_IMAG_VAR lzSetImagVar = NULL;
LZ_SET_IMAG_VAR_BY_HANDLE lzSetImagVarByHandle = NULL;
LZ_SET_INVERT_ARRAY_INDICES lzSetInvertArrayIndices = NULL;
LZ_SET_LAST_ERROR lzSetLastError = NULL;
LZ_SET_NUM_ARRAY_ELEMENT lzSetNumArrayElement = NULL;
LZ_SET_NUM_ARRAY_ELEMENT_BY_HANDLE lzSetNumArrayElementByHandle = NULL;
LZ_SET_NUM_RESULT lzSetNumResult = NULL;
LZ_SET_NUM_VAR lzSetNumVar = NULL;
LZ_SET_NUM_VAR_BY_HANDLE lzSetNumVarByHandle = NULL;
LZ_SET_OUTPUT_BASE lzSetOutputBase = NULL;
LZ_SET_QUOTE_MARK lzSetQuoteMark = NULL;
LZ_SET_RADIX_MARK lzSetRadixMark = NULL;
LZ_SET_REAL_ARRAY_ELEMENT lzSetRealArrayElement = NULL;
LZ_SET_REAL_ARRAY_ELEMENT_BY_HANDLE lzSetRealArrayElementByHandle = NULL;
LZ_SET_REAL_RESULT lzSetRealResult = NULL;
LZ_SET_REAL_VAR lzSetRealVar = NULL;
LZ_SET_REAL_VAR_BY_HANDLE lzSetRealVarByHandle = NULL;
LZ_SET_STR_ARRAY_ELEMENT lzSetStrArrayElement = NULL;
LZ_SET_STR_ARRAY_ELEMENT_BY_HANDLE lzSetStrArrayElementByHandle = NULL;
LZ_SET_STR_RESULT lzSetStrResult = NULL;
LZ_SET_STR_VAR lzSetStrVar = NULL;
LZ_SET_STR_VAR_BY_HANDLE lzSetStrVarByHandle = NULL;
LZ_SHOW_INFO_BOX lzShowInfoBox = NULL;

LZ_VERSION lzVersion = NULL;


/////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////

// Import Elzed DLL Functions

HINSTANCE hElzedDLL = NULL;

bool lzLoadElzed( void );
bool lzUnloadElzed( void );

bool lzLoadElzed( void )
{
	bool bResult = true;

	if ( hElzedDLL != NULL )
		lzUnloadElzed();

	hElzedDLL = LoadLibrary( ".\\elzed.dll" );

	if ( hElzedDLL == NULL )
		bResult = false;

	else
	{
		lzAnnotateExp = (LZ_ANNOTATE_EXP)GetProcAddress( hElzedDLL, "lzAnnotateExp" );
		lzAnnotateExpB = (LZ_ANNOTATE_EXP_B)GetProcAddress( hElzedDLL, "lzAnnotateExpB" );
		lzAnnotateParsedExp = (LZ_ANNOTATE_PARSED_EXP)GetProcAddress( hElzedDLL, "lzAnnotateParsedExp" );
		lzAnnotateParsedExpB = (LZ_ANNOTATE_PARSED_EXP_B)GetProcAddress( hElzedDLL, "lzAnnotateParsedExpB" );

		lzCheckExp = (LZ_CHECK_EXP)GetProcAddress( hElzedDLL, "lzCheckExp" );
		lzCheckExpB = (LZ_CHECK_EXP_B)GetProcAddress( hElzedDLL, "lzCheckExpB" );
		lzClearContext = (LZ_CLEAR_CONTEXT)GetProcAddress( hElzedDLL, "lzClearContext" );
		lzClearErrorCallback = (LZ_CLEAR_ERROR_CALLBACK)GetProcAddress( hElzedDLL, "lzClearErrorCallback" );
		lzClearLastError = (LZ_CLEAR_LAST_ERROR)GetProcAddress( hElzedDLL, "lzClearLastError" );
		lzCreateBoolArray = (LZ_CREATE_BOOL_ARRAY)GetProcAddress( hElzedDLL, "lzCreateBoolArray" );
		lzCreateBoolVar = (LZ_CREATE_BOOL_VAR)GetProcAddress( hElzedDLL, "lzCreateBoolVar" );
		lzCreateComplexArray = (LZ_CREATE_COMPLEX_ARRAY)GetProcAddress( hElzedDLL, "lzCreateComplexArray" );
		lzCreateComplexVar = (LZ_CREATE_COMPLEX_VAR)GetProcAddress( hElzedDLL, "lzCreateComplexVar" );
		lzCreateNumArray = (LZ_CREATE_NUM_ARRAY)GetProcAddress( hElzedDLL, "lzCreateNumArray" );
		lzCreateNumVar = (LZ_CREATE_NUM_VAR)GetProcAddress( hElzedDLL, "lzCreateNumVar" );
		lzCreatePrivateContext = (LZ_CREATE_PRIVATE_CONTEXT)GetProcAddress( hElzedDLL, "lzCreatePrivateContext" );
		lzCreatePublicContext = (LZ_CREATE_PUBLIC_CONTEXT)GetProcAddress( hElzedDLL, "lzCreatePublicContext" );
		lzCreateStrArray = (LZ_CREATE_STR_ARRAY)GetProcAddress( hElzedDLL, "lzCreateStrArray" );
		lzCreateStrVar = (LZ_CREATE_STR_VAR)GetProcAddress( hElzedDLL, "lzCreateStrVar" );

		lzDefineError = (LZ_DEFINE_ERROR)GetProcAddress( hElzedDLL, "lzDefineError" );
		lzDefineExpOp = (LZ_DEFINE_EXP_OP)GetProcAddress( hElzedDLL, "lzDefineExpOp" );
		lzDefineExpOpStr = (LZ_DEFINE_EXP_OP_STR)GetProcAddress( hElzedDLL, "lzDefineExpOpStr" );
		lzDeleteExp = (LZ_DELETE_EXP)GetProcAddress( hElzedDLL, "lzDeleteExp" );
		lzDeleteOp = (LZ_DELETE_OP)GetProcAddress( hElzedDLL, "lzDeleteOp" );
		lzDeleteVar = (LZ_DELETE_VAR)GetProcAddress( hElzedDLL, "lzDeleteVar" );
		lzDestroyPrivateContext = (LZ_DESTROY_PRIVATE_CONTEXT)GetProcAddress( hElzedDLL, "lzDestroyPrivateContext" );
		lzDestroyPublicContext = (LZ_DESTROY_PUBLIC_CONTEXT)GetProcAddress( hElzedDLL, "lzDestroyPublicContext" );

		lzEvalExpHndl = (LZ_EVAL_EXP_HNDL)GetProcAddress( hElzedDLL, "lzEvalExpHndl" );
		lzEvalExpHndlToBool = (LZ_EVAL_EXP_HNDL_TO_BOOL)GetProcAddress( hElzedDLL, "lzEvalExpHndlToBool" );
		lzEvalExpHndlToComp = (LZ_EVAL_EXP_HNDL_TO_COMP)GetProcAddress( hElzedDLL, "lzEvalExpHndlToComp" );
		lzEvalExpHndlToNum = (LZ_EVAL_EXP_HNDL_TO_NUM)GetProcAddress( hElzedDLL, "lzEvalExpHndlToNum" );
		lzEvalExpHndlToStr = (LZ_EVAL_EXP_HNDL_TO_STR)GetProcAddress( hElzedDLL, "lzEvalExpHndlToStr" );
		lzEvalExpHndlToStrB = (LZ_EVAL_EXP_HNDL_TO_STR_B)GetProcAddress( hElzedDLL, "lzEvalExpHndlToStrB" );
		lzEvalExpStr = (LZ_EVAL_EXP_STR)GetProcAddress( hElzedDLL, "lzEvalExpStr" );
		lzEvalExpStrToBool = (LZ_EVAL_EXP_STR_TO_BOOL)GetProcAddress( hElzedDLL, "lzEvalExpStrToBool" );
		lzEvalExpStrToComp = (LZ_EVAL_EXP_STR_TO_COMP)GetProcAddress( hElzedDLL, "lzEvalExpStrToComp" );
		lzEvalExpStrToNum = (LZ_EVAL_EXP_STR_TO_NUM)GetProcAddress( hElzedDLL, "lzEvalExpStrToNum" );
		lzEvalExpStrToStr = (LZ_EVAL_EXP_STR_TO_STR)GetProcAddress( hElzedDLL, "lzEvalExpStrToStr" );
		lzEvalExpStrToStrB = (LZ_EVAL_EXP_STR_TO_STR_B)GetProcAddress( hElzedDLL, "lzEvalExpStrToStrB" );

		lzGetAllowComplexResults = (LZ_GET_ALLOW_COMPLEX_RESULTS)GetProcAddress( hElzedDLL, "lzGetAllowComplexResults" );
		lzGetAllowImpliedMult = (LZ_GET_ALLOW_IMPLIED_MULT)GetProcAddress( hElzedDLL, "lzGetAllowImpliedMult" );
		lzGetAngleUnit = (LZ_GET_ANGLE_UNIT)GetProcAddress( hElzedDLL, "lzGetAngleUnit" );
		lzGetBooleanTrue = (LZ_GET_BOOLEAN_TRUE)GetProcAddress( hElzedDLL, "lzGetBooleanTrue" );
		lzGetBoolArrayElement = (LZ_GET_BOOL_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzGetBoolArrayElement" );
		lzGetBoolArrayElementByHandle = (LZ_GET_BOOL_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzGetBoolArrayElementByHandle" );
		lzGetBoolParm = (LZ_GET_BOOL_PARM)GetProcAddress( hElzedDLL, "lzGetBoolParm" );
		lzGetBoolVarValue = (LZ_GET_BOOL_VAR_VALUE)GetProcAddress( hElzedDLL, "lzGetBoolVarValue" );
		lzGetBoolVarValueByHandle = (LZ_GET_BOOL_VAR_VALUE_BY_HANDLE)GetProcAddress( hElzedDLL, "lzGetBoolVarValueByHandle" );
		lzGetComplexArrayElement = (LZ_GET_COMPLEX_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzGetComplexArrayElement" );
		lzGetComplexArrayElementByHandle = (LZ_GET_COMPLEX_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzGetComplexArrayElementByHandle" );
		lzGetComplexVarValue = (LZ_GET_COMPLEX_VAR_VALUE)GetProcAddress( hElzedDLL, "lzGetComplexVarValue" );
		lzGetComplexVarValueByHandle = (LZ_GET_COMPLEX_VAR_VALUE_BY_HANDLE)GetProcAddress( hElzedDLL, "lzGetComplexVarValueByHandle" );
		lzGetContextHandle = (LZ_GET_CONTEXT_HANDLE)GetProcAddress( hElzedDLL, "lzGetContextHandle" );
		lzGetContextName = (LZ_GET_CONTEXT_NAME)GetProcAddress( hElzedDLL, "lzGetContextName" );
		lzGetContextNameB = (LZ_GET_CONTEXT_NAME_B)GetProcAddress( hElzedDLL, "lzGetContextNameB" );
		lzGetCoordinateFormat = (LZ_GET_COORDINATE_FORMAT)GetProcAddress( hElzedDLL, "lzGetCoordinateFormat" );
		lzGetCurrentContextHandle = (LZ_GET_CURRENT_CONTEXT_HANDLE)GetProcAddress( hElzedDLL, "lzGetCurrentContextHandle" );
		lzGetCurrentContextName = (LZ_GET_CURRENT_CONTEXT_NAME)GetProcAddress( hElzedDLL, "lzGetCurrentContextName" );
		lzGetCurrentContextNameB = (LZ_GET_CURRENT_CONTEXT_NAME_B)GetProcAddress( hElzedDLL, "lzGetCurrentContextNameB" );
		lzGetDefaultVariableScope = (LZ_GET_DEFAULT_VARIABLE_SCOPE)GetProcAddress( hElzedDLL, "lzGetDefaultVariableScope" );
		lzGetErrorText = (LZ_GET_ERROR_TEXT)GetProcAddress( hElzedDLL, "lzGetErrorText" );
		lzGetErrorTextB = (LZ_GET_ERROR_TEXT_B)GetProcAddress( hElzedDLL, "lzGetErrorTextB" );
		lzGetForceComplexResults = (LZ_GET_FORCE_COMPLEX_RESULTS)GetProcAddress( hElzedDLL, "lzGetForceComplexResults" );
		lzGetFormattedResultPrecisionLimit = (LZ_GET_FORMATTED_RESULT_PRECISION_LIMIT)GetProcAddress( hElzedDLL, "lzGetFormattedResultPrecisionLimit" );
		lzGetImagParm = (LZ_GET_IMAG_PARM)GetProcAddress( hElzedDLL, "lzGetImagParm" );
		lzGetInvertArrayIndices = (LZ_GET_INVERT_ARRAY_INDICES)GetProcAddress( hElzedDLL, "lzGetInvertArrayIndices" );
		lzGetLastBoolResult = (LZ_GET_LAST_BOOL_RESULT)GetProcAddress( hElzedDLL, "lzGetLastBoolResult" );
		lzGetLastErrorID = (LZ_GET_LAST_ERROR_ID)GetProcAddress( hElzedDLL, "lzGetLastErrorID" );
		lzGetLastErrorText = (LZ_GET_LAST_ERROR_TEXT)GetProcAddress( hElzedDLL, "lzGetLastErrorText" );
		lzGetLastErrorTextB = (LZ_GET_LAST_ERROR_TEXT_B)GetProcAddress( hElzedDLL, "lzGetLastErrorTextB" );
		lzGetLastImagResult = (LZ_GET_LAST_IMAG_RESULT)GetProcAddress( hElzedDLL, "lzGetLastImagResult" );
		lzGetLastNumResult = (LZ_GET_LAST_NUM_RESULT)GetProcAddress( hElzedDLL, "lzGetLastNumResult" );
		lzGetLastParseIndex = (LZ_GET_LAST_PARSE_INDEX)GetProcAddress( hElzedDLL, "lzGetLastParseIndex" );
		lzGetLastRealResult = (LZ_GET_LAST_REAL_RESULT)GetProcAddress( hElzedDLL, "lzGetLastRealResult" );
		lzGetLastResultType = (LZ_GET_LAST_RESULT_TYPE)GetProcAddress( hElzedDLL, "lzGetLastResultType" );
		lzGetLastStrResult = (LZ_GET_LAST_STR_RESULT)GetProcAddress( hElzedDLL, "lzGetLastStrResult" );
		lzGetLastStrResultB = (LZ_GET_LAST_STR_RESULT_B)GetProcAddress( hElzedDLL, "lzGetLastStrResultB" );
		lzGetNumArrayElement = (LZ_GET_NUM_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzGetNumArrayElement" );
		lzGetNumArrayElementByHandle = (LZ_GET_NUM_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzGetNumArrayElementByHandle" );
		lzGetNumParm = (LZ_GET_NUM_PARM)GetProcAddress( hElzedDLL, "lzGetNumParm" );
		lzGetNumVarValue = (LZ_GET_NUM_VAR_VALUE)GetProcAddress( hElzedDLL, "lzGetNumVarValue" );
		lzGetNumVarValueByHandle = (LZ_GET_NUM_VAR_VALUE_BY_HANDLE)GetProcAddress( hElzedDLL, "lzGetNumVarValueByHandle" );
		lzGetOutputBase = (LZ_GET_OUTPUT_BASE)GetProcAddress( hElzedDLL, "lzGetOutputBase" );
		lzGetParmCount = (LZ_GET_PARM_COUNT)GetProcAddress( hElzedDLL, "lzGetParmCount" );
		lzGetParmSig = (LZ_GET_PARM_SIG)GetProcAddress( hElzedDLL, "lzGetParmSig" );
		lzGetParmSigB = (LZ_GET_PARM_SIG_B)GetProcAddress( hElzedDLL, "lzGetParmSigB" );
		lzGetParmType = (LZ_GET_PARM_TYPE)GetProcAddress( hElzedDLL, "lzGetParmType" );
		lzGetQuoteMark = (LZ_GET_QUOTE_MARK)GetProcAddress( hElzedDLL, "lzGetQuoteMark" );
		lzGetRadixMark = (LZ_GET_RADIX_MARK)GetProcAddress( hElzedDLL, "lzGetRadixMark" );
		lzGetRealParm = (LZ_GET_REAL_PARM)GetProcAddress( hElzedDLL, "lzGetRealParm" );
		lzGetStrArrayElement = (LZ_GET_STR_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzGetStrArrayElement" );
		lzGetStrArrayElementB = (LZ_GET_STR_ARRAY_ELEMENT_B)GetProcAddress( hElzedDLL, "lzGetStrArrayElementB" );
		lzGetStrArrayElementByHandle = (LZ_GET_STR_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzGetStrArrayElementByHandle" );
		lzGetStrArrayElementByHandleB = (LZ_GET_STR_ARRAY_ELEMENT_BY_HANDLE_B)GetProcAddress( hElzedDLL, "lzGetStrArrayElementByHandleB" );
		lzGetStrParm = (LZ_GET_STR_PARM)GetProcAddress( hElzedDLL, "lzGetStrParm" );
		lzGetStrParmB = (LZ_GET_STR_PARM_B)GetProcAddress( hElzedDLL, "lzGetStrParmB" );
		lzGetStrVarValue = (LZ_GET_STR_VAR_VALUE)GetProcAddress( hElzedDLL, "lzGetStrVarValue" );
		lzGetStrVarValueB = (LZ_GET_STR_VAR_VALUE_B)GetProcAddress( hElzedDLL, "lzGetStrVarValueB" );
		lzGetStrVarValueByHandle = (LZ_GET_STR_VAR_VALUE_BY_HANDLE)GetProcAddress( hElzedDLL, "lzGetStrVarValueByHandle" );
		lzGetStrVarValueByHandleB = (LZ_GET_STR_VAR_VALUE_BY_HANDLE_B)GetProcAddress( hElzedDLL, "lzGetStrVarValueByHandleB" );
		lzGetVarHandle = (LZ_GET_VAR_HANDLE)GetProcAddress( hElzedDLL, "lzGetVarHandle" );
		lzGetVarType = (LZ_GET_VAR_TYPE)GetProcAddress( hElzedDLL, "lzGetVarType" );
		lzGetVarTypeByHandle = (LZ_GET_VAR_TYPE_BY_HANDLE)GetProcAddress( hElzedDLL, "lzGetVarTypeByHandle" );
		
		lzInitialize = (LZ_INITIALIZE)GetProcAddress( hElzedDLL, "lzInitialize" );
		lzIsArray = (LZ_IS_ARRAY)GetProcAddress( hElzedDLL, "lzIsArray" );
		lzIsArrayHandle = (LZ_IS_ARRAY_HANDLE)GetProcAddress( hElzedDLL, "lzIsArrayHandle" );
		lzIsOp = (LZ_IS_OP)GetProcAddress( hElzedDLL, "lzIsOp" );
		lzIsSymbol = (LZ_IS_SYMBOL)GetProcAddress( hElzedDLL, "lzIsSymbol" );
		lzIsVar = (LZ_IS_VAR)GetProcAddress( hElzedDLL, "lzIsVar" );
		lzIsVarHandle = (LZ_IS_VAR_HANDLE)GetProcAddress( hElzedDLL, "lzIsVarHandle" );

		lzLinkBoolArray = (LZ_LINK_BOOL_ARRAY)GetProcAddress( hElzedDLL, "lzLinkBoolArray" );
		lzLinkBoolVar = (LZ_LINK_BOOL_VAR)GetProcAddress( hElzedDLL, "lzLinkBoolVar" );
		lzLinkCallbackOp = (LZ_LINK_CALLBACK_OP)GetProcAddress( hElzedDLL, "lzLinkCallbackOp" );
		lzLinkComplexArray = (LZ_LINK_COMPLEX_ARRAY)GetProcAddress( hElzedDLL, "lzLinkComplexArray" );
		lzLinkComplexVar = (LZ_LINK_COMPLEX_VAR)GetProcAddress( hElzedDLL, "lzLinkComplexVar" );
		lzLinkNumArray = (LZ_LINK_NUM_ARRAY)GetProcAddress( hElzedDLL, "lzLinkNumArray" );
		lzLinkNumVar = (LZ_LINK_NUM_VAR)GetProcAddress( hElzedDLL, "lzLinkNumVar" );
		lzLinkStrArray = (LZ_LINK_STR_ARRAY)GetProcAddress( hElzedDLL, "lzLinkStrArray" );
		lzLinkStrVar = (LZ_LINK_STR_VAR)GetProcAddress( hElzedDLL, "lzLinkStrVar" );
		lzLockContext = (LZ_LOCK_CONTEXT)GetProcAddress( hElzedDLL, "lzLockContext" );

		lzParseExp = (LZ_PARSE_EXP)GetProcAddress( hElzedDLL, "lzParseExp" );

		lzReadExpOp = (LZ_READ_EXP_OP)GetProcAddress( hElzedDLL, "lzReadExpOp" );
		lzReadExpOpStr = (LZ_READ_EXP_OP_STR)GetProcAddress( hElzedDLL, "lzReadExpOpStr" );
		lzRelease = (LZ_RELEASE)GetProcAddress( hElzedDLL, "lzRelease" );
		lzReleaseContext = (LZ_RELEASE_CONTEXT)GetProcAddress( hElzedDLL, "lzReleaseContext" );
		lzReset = (LZ_RESET)GetProcAddress( hElzedDLL, "lzReset" );
		lzResetDefaultContext = (LZ_RESET_DEFAULT_CONTEXT)GetProcAddress( hElzedDLL, "lzResetDefaultContext" );
		lzRevertParsedExp = (LZ_REVERT_PARSED_EXP)GetProcAddress( hElzedDLL, "lzRevertParsedExp" );
		lzRevertParsedExpB = (LZ_REVERT_PARSED_EXP_B)GetProcAddress( hElzedDLL, "lzRevertParsedExpB" );

		lzSetAllowComplexResults = (LZ_SET_ALLOW_COMPLEX_RESULTS)GetProcAddress( hElzedDLL, "lzSetAllowComplexResults" );
		lzSetAllowImpliedMult = (LZ_SET_ALLOW_IMPLIED_MULT)GetProcAddress( hElzedDLL, "lzSetAllowImpliedMult" );
		lzSetAngleUnit = (LZ_SET_ANGLE_UNIT)GetProcAddress( hElzedDLL, "lzSetAngleUnit" );
		lzSetBooleanTrue = (LZ_SET_BOOLEAN_TRUE)GetProcAddress( hElzedDLL, "lzSetBooleanTrue" );
		lzSetBoolArrayElement = (LZ_SET_BOOL_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzSetBoolArrayElement" );
		lzSetBoolArrayElementByHandle = (LZ_SET_BOOL_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetBoolArrayElementByHandle" );
		lzSetBoolResult = (LZ_SET_BOOL_RESULT)GetProcAddress( hElzedDLL, "lzSetBoolResult" );
		lzSetBoolVar = (LZ_SET_BOOL_VAR)GetProcAddress( hElzedDLL, "lzSetBoolVar" );
		lzSetBoolVarByHandle = (LZ_SET_BOOL_VAR_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetBoolVarByHandle" );
		lzSetComplexArrayElement = (LZ_SET_COMPLEX_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzSetComplexArrayElement" );
		lzSetComplexArrayElementByHandle = (LZ_SET_COMPLEX_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetComplexArrayElementByHandle" );
		lzSetComplexVar = (LZ_SET_COMPLEX_VAR)GetProcAddress( hElzedDLL, "lzSetComplexVar" );
		lzSetComplexVarByHandle = (LZ_SET_COMPLEX_VAR_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetComplexVarByHandle" );
		lzSetContext = (LZ_SET_CONTEXT)GetProcAddress( hElzedDLL, "lzSetContext" );
		lzSetCoordinateFormat = (LZ_SET_COORDINATE_FORMAT)GetProcAddress( hElzedDLL, "lzSetCoordinateFormat" );
		lzSetDefaultContext = (LZ_SET_DEFAULT_CONTEXT)GetProcAddress( hElzedDLL, "lzSetDefaultContext" );
		lzSetDefaultVariableScope = (LZ_SET_DEFAULT_VARIABLE_SCOPE)GetProcAddress( hElzedDLL, "lzSetDefaultVariableScope" );
		lzSetErrorCallback = (LZ_SET_ERROR_CALLBACK)GetProcAddress( hElzedDLL, "lzSetErrorCallback" );
		lzSetForceComplexResults = (LZ_SET_FORCE_COMPLEX_RESULTS)GetProcAddress( hElzedDLL, "lzSetForceComplexResults" );
		lzSetFormattedResultPrecisionLimit = (LZ_SET_FORMATTED_RESULT_PRECISION_LIMIT)GetProcAddress( hElzedDLL, "lzSetFormattedResultPrecisionLimit" );
		lzSetImagArrayElement = (LZ_SET_IMAG_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzSetImagArrayElement" );
		lzSetImagArrayElementByHandle = (LZ_SET_IMAG_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetImagArrayElementByHandle" );
		lzSetImagResult = (LZ_SET_IMAG_RESULT)GetProcAddress( hElzedDLL, "lzSetImagResult" );
		lzSetImagVar = (LZ_SET_IMAG_VAR)GetProcAddress( hElzedDLL, "lzSetImagVar" );
		lzSetImagVarByHandle = (LZ_SET_IMAG_VAR_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetImagVarByHandle" );
		lzSetInvertArrayIndices = (LZ_SET_INVERT_ARRAY_INDICES)GetProcAddress( hElzedDLL, "lzSetInvertArrayIndices" );
		lzSetLastError = (LZ_SET_LAST_ERROR)GetProcAddress( hElzedDLL, "lzSetLastError" );
		lzSetNumArrayElement = (LZ_SET_NUM_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzSetNumArrayElement" );
		lzSetNumArrayElementByHandle = (LZ_SET_NUM_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetNumArrayElementByHandle" );
		lzSetNumResult = (LZ_SET_NUM_RESULT)GetProcAddress( hElzedDLL, "lzSetNumResult" );
		lzSetNumVar = (LZ_SET_NUM_VAR)GetProcAddress( hElzedDLL, "lzSetNumVar" );
		lzSetNumVarByHandle = (LZ_SET_NUM_VAR_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetNumVarByHandle" );
		lzSetOutputBase = (LZ_SET_OUTPUT_BASE)GetProcAddress( hElzedDLL, "lzSetOutputBase" );
		lzSetQuoteMark = (LZ_SET_QUOTE_MARK)GetProcAddress( hElzedDLL, "lzSetQuoteMark" );
		lzSetRadixMark = (LZ_SET_RADIX_MARK)GetProcAddress( hElzedDLL, "lzSetRadixMark" );
		lzSetRealArrayElement = (LZ_SET_REAL_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzSetRealArrayElement" );
		lzSetRealArrayElementByHandle = (LZ_SET_REAL_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetRealArrayElementByHandle" );
		lzSetRealResult = (LZ_SET_REAL_RESULT)GetProcAddress( hElzedDLL, "lzSetRealResult" );
		lzSetRealVar = (LZ_SET_REAL_VAR)GetProcAddress( hElzedDLL, "lzSetRealVar" );
		lzSetRealVarByHandle = (LZ_SET_REAL_VAR_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetRealVarByHandle" );
		lzSetStrArrayElement = (LZ_SET_STR_ARRAY_ELEMENT)GetProcAddress( hElzedDLL, "lzSetStrArrayElement" );
		lzSetStrArrayElementByHandle = (LZ_SET_STR_ARRAY_ELEMENT_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetStrArrayElementByHandle" );
		lzSetStrResult = (LZ_SET_STR_RESULT)GetProcAddress( hElzedDLL, "lzSetStrResult" );
		lzSetStrVar = (LZ_SET_STR_VAR)GetProcAddress( hElzedDLL, "lzSetStrVar" );
		lzSetStrVarByHandle = (LZ_SET_STR_VAR_BY_HANDLE)GetProcAddress( hElzedDLL, "lzSetStrVarByHandle" );
		lzShowInfoBox = (LZ_SHOW_INFO_BOX)GetProcAddress( hElzedDLL, "lzShowInfoBox" );

		lzVersion = (LZ_VERSION)GetProcAddress( hElzedDLL, "lzVersion" );
	}

	return bResult;
}

bool lzUnloadElzed( void )
{
	bool bResult = true;

	if ( hElzedDLL != NULL )
	{
		FreeLibrary( hElzedDLL );
		hElzedDLL = NULL;
	}

	lzAnnotateExp = NULL;
	lzAnnotateExpB = NULL;
	lzAnnotateParsedExp = NULL;
	lzAnnotateParsedExpB = NULL;

	lzCheckExp = NULL;
	lzCheckExpB = NULL;
	lzClearContext = NULL;
	lzClearErrorCallback = NULL;
	lzClearLastError = NULL;
	lzCreateBoolArray = NULL;
	lzCreateBoolVar = NULL;
	lzCreateComplexArray = NULL;
	lzCreateComplexVar = NULL;
	lzCreateNumArray = NULL;
	lzCreateNumVar = NULL;
	lzCreatePrivateContext = NULL;
	lzCreatePublicContext = NULL;
	lzCreateStrArray = NULL;
	lzCreateStrVar = NULL;

	lzDefineError = NULL;
	lzDefineExpOp = NULL;
	lzDefineExpOpStr = NULL;
	lzDeleteExp = NULL;
	lzDeleteOp = NULL;
	lzDeleteVar = NULL;
	lzDestroyPrivateContext = NULL;
	lzDestroyPublicContext = NULL;

	lzEvalExpHndl = NULL;
	lzEvalExpHndlToBool = NULL;
	lzEvalExpHndlToComp = NULL;
	lzEvalExpHndlToNum = NULL;
	lzEvalExpHndlToStr = NULL;
	lzEvalExpHndlToStrB = NULL;
	lzEvalExpStr = NULL;
	lzEvalExpStrToBool = NULL;
	lzEvalExpStrToComp = NULL;
	lzEvalExpStrToNum = NULL;
	lzEvalExpStrToStr = NULL;
	lzEvalExpStrToStrB = NULL;

	lzGetAllowComplexResults = NULL;
	lzGetAllowImpliedMult = NULL;
	lzGetAngleUnit = NULL;
	lzGetBooleanTrue = NULL;
	lzGetBoolArrayElement = NULL;
	lzGetBoolArrayElementByHandle = NULL;
	lzGetBoolParm = NULL;
	lzGetBoolVarValue = NULL;
	lzGetBoolVarValueByHandle = NULL;
	lzGetComplexArrayElement = NULL;
	lzGetComplexArrayElementByHandle = NULL;
	lzGetComplexVarValue = NULL;
	lzGetComplexVarValueByHandle = NULL;
	lzGetContextHandle = NULL;
	lzGetContextName = NULL;
	lzGetContextNameB = NULL;
	lzGetCoordinateFormat = NULL;
	lzGetCurrentContextHandle = NULL;
	lzGetCurrentContextName = NULL;
	lzGetCurrentContextNameB = NULL;
	lzGetDefaultVariableScope = NULL;
	lzGetErrorText = NULL;
	lzGetErrorTextB = NULL;
	lzGetForceComplexResults = NULL;
	lzGetFormattedResultPrecisionLimit = NULL;
	lzGetImagParm = NULL;
	lzGetInvertArrayIndices = NULL;
	lzGetLastBoolResult = NULL;
	lzGetLastErrorID = NULL;
	lzGetLastErrorText = NULL;
	lzGetLastErrorTextB = NULL;
	lzGetLastImagResult = NULL;
	lzGetLastNumResult = NULL;
	lzGetLastParseIndex = NULL;
	lzGetLastRealResult = NULL;
	lzGetLastResultType = NULL;
	lzGetLastStrResult = NULL;
	lzGetLastStrResultB = NULL;
	lzGetNumArrayElement = NULL;
	lzGetNumArrayElementByHandle = NULL;
	lzGetNumParm = NULL;
	lzGetNumVarValue = NULL;
	lzGetNumVarValueByHandle = NULL;
	lzGetOutputBase = NULL;
	lzGetParmCount = NULL;
	lzGetParmSig = NULL;
	lzGetParmSigB = NULL;
	lzGetParmType = NULL;
	lzGetQuoteMark = NULL;
	lzGetRadixMark = NULL;
	lzGetRealParm = NULL;
	lzGetStrArrayElement = NULL;
	lzGetStrArrayElementB = NULL;
	lzGetStrArrayElementByHandle = NULL;
	lzGetStrArrayElementByHandleB = NULL;
	lzGetStrParm = NULL;
	lzGetStrParmB = NULL;
	lzGetStrVarValue = NULL;
	lzGetStrVarValueB = NULL;
	lzGetStrVarValueByHandle = NULL;
	lzGetStrVarValueByHandleB = NULL;
	lzGetVarHandle = NULL;
	lzGetVarType = NULL;
	lzGetVarTypeByHandle = NULL;
	
	lzInitialize = NULL;
	lzIsArray = NULL;
	lzIsArrayHandle = NULL;
	lzIsOp = NULL;
	lzIsSymbol = NULL;
	lzIsVar = NULL;
	lzIsVarHandle = NULL;

	lzLinkBoolArray = NULL;
	lzLinkBoolVar = NULL;
	lzLinkCallbackOp = NULL;
	lzLinkComplexArray = NULL;
	lzLinkComplexVar = NULL;
	lzLinkNumArray = NULL;
	lzLinkNumVar = NULL;
	lzLinkStrVar = NULL;
	lzLinkStrArray = NULL;
	lzLockContext = NULL;

	lzParseExp = NULL;

	lzReadExpOp = NULL;
	lzReadExpOpStr = NULL;
	lzRelease = NULL;
	lzReleaseContext = NULL;
	lzReset = NULL;
	lzResetDefaultContext = NULL;
	lzRevertParsedExp = NULL;
	lzRevertParsedExpB = NULL;

	lzSetAllowComplexResults = NULL;
	lzSetAllowImpliedMult = NULL;
	lzSetAngleUnit = NULL;
	lzSetBooleanTrue = NULL;
	lzSetBoolArrayElement = NULL;
	lzSetBoolArrayElementByHandle = NULL;
	lzSetBoolResult = NULL;
	lzSetBoolVar = NULL;
	lzSetBoolVarByHandle = NULL;
	lzSetComplexArrayElement = NULL;
	lzSetComplexArrayElementByHandle = NULL;
	lzSetComplexVar = NULL;
	lzSetComplexVarByHandle = NULL;
	lzSetContext = NULL;
	lzSetCoordinateFormat = NULL;
	lzSetDefaultContext = NULL;
	lzSetDefaultVariableScope = NULL;
	lzSetErrorCallback = NULL;
	lzSetForceComplexResults = NULL;
	lzSetFormattedResultPrecisionLimit = NULL;
	lzSetImagArrayElement = NULL;
	lzSetImagArrayElementByHandle = NULL;
	lzSetImagResult = NULL;
	lzSetImagVar = NULL;
	lzSetImagVarByHandle = NULL;
	lzSetInvertArrayIndices = NULL;
	lzSetLastError = NULL;
	lzSetNumArrayElement = NULL;
	lzSetNumArrayElementByHandle = NULL;
	lzSetNumResult = NULL;
	lzSetNumVar = NULL;
	lzSetNumVarByHandle = NULL;
	lzSetOutputBase = NULL;
	lzSetQuoteMark = NULL;
	lzSetRadixMark = NULL;
	lzSetRealArrayElement = NULL;
	lzSetRealArrayElementByHandle = NULL;
	lzSetRealResult = NULL;
	lzSetRealVar = NULL;
	lzSetRealVarByHandle = NULL;
	lzSetStrArrayElement = NULL;
	lzSetStrArrayElementByHandle = NULL;
	lzSetStrResult = NULL;
	lzSetStrVar = NULL;
	lzSetStrVarByHandle = NULL;
	lzShowInfoBox = NULL;

	lzVersion = NULL;

	return bResult;
}

#endif	// __LZElzedDLL__